<?php 
include ('includes/header.php');

//table name
$table_name = "vpn";
$page = "vpn.php";
$download_path = "api/vpnfiles/";
$zipPath = 'api/ovpn_bundle.zip';

$data = ['username' => 'Username955','macaddress' => '10:20:30:40:','feedback_content' => 'Good'];
//$db->insertIfEmpty($table_name, $data);

//table call
$res = $db->select($table_name, '*', '', '');

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	$ftd = $download_path . $_GET['file'];
	unlink($ftd);
	zipOnlyOvpnFiles($download_path,$zipPath);
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

function zipOnlyOvpnFiles($folderPath, $zipFilePath) {
    $folderPath = rtrim($folderPath, '/') . '/';
    if (!is_dir($folderPath)) {
        return ['success' => false, 'message' => 'Folder does not exist.'];
    }

    // Step 1: Delete all non-OVPN files
    $files = scandir($folderPath);
    foreach ($files as $file) {
        $filePath = $folderPath . $file;
        if (is_file($filePath)) {
            $ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
            if ($ext !== 'ovpn') {
                unlink($filePath); // delete non-ovpn files
            }
        }
    }

    // Step 2: Create zip archive
    $zip = new ZipArchive();
    if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
        return ['success' => false, 'message' => 'Failed to create zip file.'];
    }

    // Add remaining .ovpn files to the zip
    $ovpnFiles = glob($folderPath . '*.ovpn');
    foreach ($ovpnFiles as $ovpnFile) {
        $zip->addFile($ovpnFile, basename($ovpnFile));
    }

    $zip->close();

    return ['success' => true, 'message' => 'ZIP created successfully.', 'zip_path' => $zipFilePath];
}

?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content" style="background-color: black;">
			<div class="modal-header">
				<h2 style="color: white;">Confirm</h2>
			</div>
			<div class="modal-body" style="color: white;">
				Do you really want to delete?
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
				<a style="color: white;" class="btn btn-danger btn-ok">Delete</a>
			</div>
		</div>
	</div>
</div>

		<div class="col-md-12 mx-auto ctmain-table">
			<div class="card-body">
				<div class="card ctcard">
					<div class="card-header card-header-warning">
						<center>
							<h2><i class="icon icon-commenting"></i> OVPN's</h2>
						</center>
					</div>
					<div class="card-body" >
					    <div class="col-12">
					        <center>
						
	        			<a id="button" href="./<?='vpn_choose.php' ?>" class="btn btn-info">New OVPN</a>
	        		</center>
    			    </div>
						<br>
						<div class="table-responsive">
							<table class="table table-striped table-sm">
							<thead style="color:white!important">
								<tr>
									<th>Location</th>
									<th>File Name</th>
									<th>Username</th>
									<th>Password</th>
									<th>&nbspDelete</th>
								</tr>
							</thead>
							<?php foreach ($res as $row) {
							?>
							<?php
                                $params = [
                                  'delete' => $row['id'],
                                  'file' => $row['file_name']
                                ];
                                ?>
							<tbody>
								<tr>
									<td><?=$row['location'] ?></a></td>
									<td><?=$row['file_name'] ?></td>
									<td><?=$row['username'] ?></a></td>
									<td><?=$row['password'] ?></a></td>
									<td><a class="btn btn-danger btn-ok" href="#" data-href="<?=$page . '?' . http_build_query($params) ?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
									</td>
								</tr>
							</tbody>
							<?php
							}?>
							</table>
						</div>
						</div>
					</div>
				</div>


	</div>

<?php include ('includes/footer.php');?>

</body>
</html>