<?php
$league_id = $_GET['id'];
$league_name = $_GET['name'];
// Function to fetch and process content from URL
function fetch_and_process_content($url) {
    $content = file_get_contents($url);

    // Replace specific text in the content
    $text_replacements = array(
        "../" => "https://www.thesportsdb.com/",
        "/images/icons/flags/" => "https://www.thesportsdb.com/images/icons/flags/",
        "&nbsp" => " ",
        "/images/icons/calendar.png" => "https://www.thesportsdb.com/images/icons/calendar.png",
        "/images/icons/time.png" => "https://www.thesportsdb.com/images/icons/time.png"
    );

    $content = str_replace(array_keys($text_replacements), array_values($text_replacements), $content);
    $content = preg_replace('/(<img[^>]+)(>)/i', '$1 style="border-radius: 10px;"$2', $content);

    // Load the content into a DOMDocument
    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($content);
    libxml_use_internal_errors(false);

    // Remove href attributes from all anchor tags
    $xpath = new DOMXPath($dom);
    $linkElements = $xpath->query('//a');
    foreach ($linkElements as $linkElement) {
        $linkElement->removeAttribute('href');
    }

    // Style all td elements
    $tdElements = $xpath->query('//td');
    foreach ($tdElements as $tdElement) {
        $tdElement->setAttribute('style', 'text-align: left; vertical-align: top; width: 20%; color: white; font-weight: bold; text-shadow: 2px 2px 2px black;');
    }

    return $dom;
}

// Fetch soccer leagues and process the content
echo "<!DOCTYPE html>
<html>
<head>
    <title>Sports Guide: Soccer Leagues</title>
    <style>
        body {
            background-size: cover;
            background-repeat: no-repeat;
            background-attachment: fixed;
            font-family: Arial, sans-serif;
            color: white;
        }
        .container {
            width: 97%;
            margin: auto;
            overflow: hidden;
            background-color: rgba(0, 0, 0, 0.1);
            padding: 20px;
            border-radius: 10px;
        }
        .event {
            background-color: #fff;
            margin: 10px 0;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            color: black;
        }
        .event h2 {
            margin: 0;
            color: #333;
        }
        .event p {
            margin: 5px 0;
            color: #666;
        }
    </style>
</head>
<body>
    <div class='container'>";

    $url = "https://www.thesportsdb.com/league/" . $league_id;
    $dom = fetch_and_process_content($url);

    echo "<h1>$league_name Fixtures and Results</h1>";

    $table = $dom->getElementsByTagName('table')->item(0);
    if ($table) {
        echo $dom->saveHTML($table);
    } else {
        echo "<p>$league_name table not found.</p>";
    }

echo "  </div>
    <script>
    let scrollSpeed = 0.5; // Adjust this value to control the initial scrolling speed
    let scrollTop = 0;
    let autoScroll = true;

    function scroll() {
        if (autoScroll) {
            scrollTop += scrollSpeed;

            if (scrollTop >= document.body.scrollHeight - window.innerHeight) {
                scrollTop = 0;
            }

            window.scrollTo(0, scrollTop);
        }
        requestAnimationFrame(scroll);
    }

    function scrollUp() {
        window.scrollBy(0, -50);
    }

    function scrollDown() {
        window.scrollBy(0, 50);
    }

    function speedUp() {
        scrollSpeed += 0.2;
    }

    function slowDown() {
        if (scrollSpeed > 0.2) {
            scrollSpeed -= 0.2;
        }
    }

    function toggleAutoScroll() {
        autoScroll = !autoScroll;
    }

    // Start scrolling after a 1-second delay
    window.addEventListener('load', () => {
        setTimeout(scroll, 1000);
    });

    // WebSocket setup
    const socket = new WebSocket('ws://localhost:8080');

    socket.addEventListener('message', function (event) {
        const message = event.data;

        if (message === 'stop') {
            autoScroll = false;
        } else if (message === 'start') {
            autoScroll = true;
        } else if (message === 'up') {
            scrollUp();
        } else if (message === 'down') {
            scrollDown();
        } else if (message === 'speedup') {
            speedUp();
        } else if (message === 'slowdown') {
            slowDown();
        }
    });

    socket.addEventListener('open', function (event) {
        console.log('Connected to WebSocket server');
    });

    socket.addEventListener('close', function (event) {
        console.log('Disconnected from WebSocket server');
    });

    socket.addEventListener('error', function (event) {
        console.error('WebSocket error:', event);
    });
    </script>
</body>
</html>";
?>
