<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoplaying Backdrops with Polish Logos</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        #backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .logo-container {
            position: absolute;
            top: 95px; /* Adjust top position as needed */
            right: 16px; /* Adjust right position as needed */
            z-index: 1; /* Ensures logo is above the backdrop */
            padding: 10px; /* Add padding to the logo container */
            background-color: rgba(0, 0, 0, 0.5); /* Background color with transparency */
            border-radius: 5px; /* Rounded corners */
            color: #fff; /* Text color */
            border: 2px solid green; /* Kolor podświetlenia obramowania */
            box-shadow: 0 0 10px green; /* Efekt podświetlenia (glow) */
        }
        .logo {
            max-width: 250px; /* Adjust size of the logo as needed */
        }
        .movie-info {
            max-width: 300px; /* Adjust maximum width of the movie info container */
            margin-top: 10px; /* Adjust margin top as needed */
            font-size: 10px; /* Adjust font size to make description text smaller */
        }
        .movie-title {
            color: orange; /* Set the color of the movie title to orange */
        }
    </style>
</head>
<body>
    <?php
    $jsonData = file_get_contents('tmdbkey.json');
    $data = json_decode($jsonData, true);
    if ($data !== null) {
        $tmdbkey = $data['tmdbkey'];
        $tmdblanguage = $data['tmdlng'];
    }
    ?>
    <img id="backdrop">
    <div class="logo-container">
        <img id="logo" class="logo">
        <div id="movie-info" class="movie-info"></div>
    </div>

    <script>
        const apiKey = "<?php echo $tmdbkey; ?>"; // Replace with your TMDb API key
        const language =  "<?php echo $tmdblanguage; ?>";
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularPolishMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać popularnych filmów');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Błąd podczas pobierania popularnych filmów:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać tła filmu');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0].file_path; // Assuming the first backdrop in the array
                return `https://image.tmdb.org/t/p/original${backdropPath}`;
            } catch (error) {
                console.error('Błąd podczas pobierania tła filmu:', error);
            }
        }

        async function fetchMovieLogo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&append_to_response=images`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać logo filmu');
                }
                const data = await response.json();
                const logos = data.images.logos;
                let polishLogo = logos.find(logo => logo.iso_639_1 === {language});
                if (!polishLogo) {
                    polishLogo = logos.find(logo => logo.iso_639_1 === 'en'); // Fallback to English logo if Polish logo not available
                }
                if (polishLogo) {
                    return `https://image.tmdb.org/t/p/w500${polishLogo.file_path}`;
                } else {
                    return null;
                }
            } catch (error) {
                console.error('Błąd podczas pobierania logo filmu:', error);
            }
        }

        async function fetchMovieInfo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać informacji o filmie');
                }
                const data = await response.json();
                return {
                    title: data.title,
                    releaseDate: data.release_date,
                    overview: data.overview
                };
            } catch (error) {
                console.error('Błąd podczas pobierania informacji o filmie:', error);
            }
        }

        async function updateBackdropAndLogo() {
            if (movieIds.length === 0) {
                console.error('Brak dostępnych identyfikatorów filmów.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const backdropUrl = await fetchMovieBackdrop(movieId);
                if (backdropUrl) {
                    const backdrop = document.getElementById('backdrop');
                    backdrop.src = backdropUrl;
                }

                const logoUrl = await fetchMovieLogo(movieId);
                if (logoUrl) {
                    const logo = document.getElementById('logo');
                    logo.src = logoUrl;
                } else {
                    const logo = document.getElementById('logo');
                    logo.src = ''; // Ensure logo is cleared if not available
                }

                const movieInfo = await fetchMovieInfo(movieId);
                if (movieInfo) {
                    const movieInfoElement = document.getElementById('movie-info');
                    movieInfoElement.innerHTML = `
                        <strong class="movie-title">${movieInfo.title}</strong> (${movieInfo.releaseDate.substring(0, 4)})<br>
                        ${movieInfo.overview}
                    `;
                }

                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Błąd podczas aktualizacji tła, logo i informacji o filmie:', error);
            }
        }

        fetchPopularPolishMovieIds().then(() => {
            setInterval(updateBackdropAndLogo, 6000); // Change backdrop, logo, and movie info every 6 seconds (adjust as needed)
            updateBackdropAndLogo(); // Initial update
        });
    </script>
</body>
</html>
