<?php 
include ('includes/header.php');
include ('includes/json_utils.php');


$page_name = 'interface';
$table_name = "addui";
$db_response = array(); 

$res = $db->select($table_name, '*', '', '');


$default_item_1 = array(
    'theme_name' => 'Red',
    'assets_name' => 'red',
    'priv_image' => './ui/ui_1.gif'

);

$default_item_2 = array(
    'theme_name' => 'Fancy',
    'assets_name' => 'fancy',
    'priv_image' => './ui/ui_2.gif'

);

$default_item_3 = array(
    'theme_name' => 'Wood',
    'assets_name' => 'wood',
    'priv_image' => './ui/ui_3.gif'

);

array_push($db_response, $default_item_1);
array_push($db_response, $default_item_2);
array_push($db_response, $default_item_3);


foreach ($res as $row) {
    $row_array['theme_name'] = $row['theme_name']; 
	$row_array['assets_name'] = $row['assets_name']; 
    $row_array['priv_image'] = $row['priv_image']; 
	array_push($db_response,$row_array); 
}
    


if (isset($_POST['submit']) && isset($_POST['data'])) {
  foreach ($_POST['data'] as $id => $fields) {
      updateJsonRecordByIdMulty($id, $fields);
  }

  echo "<script>window.location.href='" . $page_name . ".php?status=1'</script>";
}

?>

<div class="col-md-12 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Interface (UI) design</h2>
                </center>
            </div>

            <div class="card-body">
                <form method="post">
                    <div class="form-group ctinput">
                        <input type="hidden" name="data[41][preffile]" value="RTXRebrand">
                        <input type="hidden" name="data[41][preftype]" value="string">
                        <input type="hidden" name="data[41][prefname]" value="set_ui">
                        <select id="layout" name="data[41][mods]">
                        <?php
                            $current_selection = getmodsbyid('41');
                            foreach ($db_response as $item) {
                                $value = htmlspecialchars($item['assets_name']);
                                $label = htmlspecialchars($item['theme_name']);
                                $selected = ($current_selection == $value) ? 'selected' : '';
                                echo "<option value=\"$value\" $selected>$label</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
            <div class="grid-container">
                <?php foreach ($db_response as $item): ?>
                    <div class="grid-item">
                        <img src="<?php echo htmlspecialchars($item['priv_image']); ?>" alt="<?php echo htmlspecialchars($item['theme_name']); ?>">
                        <div class="image-text"><?php echo htmlspecialchars($item['theme_name']); ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<style>
.grid-container {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 30px;
    /* Adjust the gap between images */
    padding: 10px;
}

.grid-item {
    text-align: center;
}

.grid-item img {
    max-width: 100%;
    height: 100%;
}

.image-text {
    margin-top: 5px;
    font-size: 16px;
    color: #fff;
}
</style>
<?php include ('includes/footer.php');?>