<?php
ini_set('display_errors', 0);
include(__DIR__ . '/functions.php');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$log_check = $db->select('user', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!isset($_SESSION['name']) == $loggedinuser) {
    header("location:"."index.php");
    exit();
}

// Corrected Block
if (isset($_REQUEST['logout'])) {
    session_destroy();
    setcookie("auth", "");
    header("Location: index.php");
    exit;
}

$time = $_SERVER['REQUEST_TIME'];

$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    session_start();
}
$_SESSION['LAST_ACTIVITY'] = $time;

function sanitize($data) {
    $data = trim($data);
    $data = htmlspecialchars($data, ENT_QUOTES );
    $data = SQLite3::escapeString($data);
    return $data;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>RTX Rebrand V2 Panel</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="https://appsrebrand.com/">
    <link rel="icon" type="image/x-icon" href="./img/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="./img/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="./img/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./img/favicon-16x16.png">
    <link rel="manifest" href="./img/site.webmanifest">
    <link rel="stylesheet" href="https://bootswatch.com/5/solar/bootstrap.min.css"
        integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>

<div id="net-canvas"></div>

<body>
    <div class="d-flex" id="wrapper">
        <div class="" id="sidebar-wrapper">
            <div class="sidebar-heading">
                <div class="sidebar-logo">
                    <img src="./img/login_logo.png" alt="logo">
                </div>
            </div>
            <span><a class="list-group-item" href=" <?php echo $config_ini['contact']; ?>"
                    target="_blank"><?php echo $config_ini['panel_name']; ?></a> </span>
            <div class="list-group list-group-flush">
                <a class="list-group-item list-group-item-action " href="main.php">
                    <i class="material-icons">dns</i> DNS Settings </a>
                <a class="list-group-item list-group-item-action " href="note.php">
                    <i class="material-icons">announcement</i> Announcements </a>
                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">ad_units</i> Ad Management</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                        <a class="list-group-item list-group-item-action " href="text_ads.php">
                            <i  class="material-icons">text_fields</i> Text Ads </a>
                        <a class="list-group-item list-group-item-action " href="popup_ads.php">
                            <i class="material-icons">open_in_new</i> Pop-up Ads </a>
                    </div>
                </div>

                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">wallpaper</i> Background Settings</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                        <a class="list-group-item list-group-item-action " href="ads_settings.php">
                            <i class="material-icons">ad_units</i> Ad Type </a>
                        <a class="list-group-item list-group-item-action " href="menads.php">
                            <i class="material-icons">handyman</i> Manual Ads </a>
                        <a class="list-group-item list-group-item-action " href="tmdb_api.php">
                            <i class="material-icons">api</i> TMDB API Key </a>
                        <a class="list-group-item list-group-item-action " href="tmdb_lang.php">
                            <i class="material-icons">language</i> TMDB Language </a>
                        <a class="list-group-item list-group-item-action " href="auto_layout.php">
                            <i class="material-icons">auto_awesome</i> Auto Ad Layout </a>
                        <a class="list-group-item list-group-item-action " href="backdrip_image.php">
                            <i class="material-icons">wallpaper</i> Background Image </a>  
                        <a class="list-group-item list-group-item-action " href="backdrop_tube.php">
                            <i class="material-icons">play_arrow</i> Background YouTube (Video) </a>  
                            
                        <a class="list-group-item list-group-item-action " href="text_animation.php">
                            <i class="material-icons">format_color_text</i> Text Animation </a>     
                    </div>
                </div>

                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">feedback</i> Reports and Feedback</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                        <a class="list-group-item list-group-item-action " href="report.php">
                            <i class="material-icons">report</i> App Reports </a>
                        <a class="list-group-item list-group-item-action " href="feedback.php">
                            <i class="material-icons">comment</i> App Feedback </a>
                    </div>
                </div>


                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">settings_applications</i> App Settings</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                        <a class="list-group-item list-group-item-action " href="app_mods.php">
                            <i class="material-icons">tune</i> App Mod </a>
                        <a class="list-group-item list-group-item-action " href="intro_settings.php">
                            <i class="material-icons">play_circle</i> Intro Settings </a>
                        <a class="list-group-item list-group-item-action " href="maintenance.php">
                            <i class="material-icons">build</i> Maintenance Mode </a>
                        <a class="list-group-item list-group-item-action " href="force_app_settings.php">
                            <i class="material-icons">settings</i> Force App Settings </a>   
                        <a class="list-group-item list-group-item-action " href="general_settings.php">
                            <i class="material-icons">settings</i> General Settings </a>
                        <a class="list-group-item list-group-item-action " href="automation_settings.php">
                            <i class="material-icons">auto_awesome</i> Automation Settings </a>
                        <a class="list-group-item list-group-item-action " href="player_selection.php">
                            <i class="material-icons">video_settings</i> Player Selection </a>
                        <a class="list-group-item list-group-item-action " href="buildin_player_settings.php">
                            <i class="material-icons">videocam</i> Built-in Player Settings </a>
                    </div>
                </div>



                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">sports</i> Sports</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                        <a class="list-group-item list-group-item-action " href="sport_settings.php">
                            <i class="material-icons">sports_soccer</i> Sports Settings </a>
                        <a class="list-group-item list-group-item-action " href="leagues.php">
                            <i class="material-icons">emoji_events</i> League ID </a>
                        <a class="list-group-item list-group-item-action " href="leagues_widget.php">
                            <i class="material-icons">widgets</i> League Widget ID </a>
                        <a class="list-group-item list-group-item-action " href="leagues_timeshift.php">
                            <i class="material-icons">schedule</i> League Timeshift (Timezone) </a>
                        <a class="list-group-item list-group-item-action " href="extra_sports.php">
                            <i class="material-icons">add_circle</i> Extra Sports Link </a>
                        <a class="list-group-item list-group-item-action " href="tsdp_api.php">
                            <i class="material-icons">api</i> Thesportsdb API </a>
                    </div>
                </div>


                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">dark_mode</i> User Interface</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                    <a class="list-group-item list-group-item-action " href="interface.php">
                        <i class="material-icons">dark_mode</i> User Interface </a>
                    <a class="list-group-item list-group-item-action " href="addui.php">
                        <i class="material-icons">brush</i> Custom Design </a>    


                    <a class="list-group-item list-group-item-action " href="#">
                        <i class="material-icons">local_florist</i> Focus Animation (Coming Soon)</a>   
                    <a class="list-group-item list-group-item-action " href="https://davinci.rtxrebrands.com/assetstore/">
                        <i class="material-icons">shopping_cart</i> Asset Store</a>     
                    </div>
                </div>

                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons" >vpn_lock</i> Ovpn Settings</a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                    <a class="list-group-item list-group-item-action " href="vpn.php">
                        <i class="material-icons">vpn_lock</i> Ovpn's </a>
                    <a class="list-group-item list-group-item-action " href="vpn_credentials_settings.php">
                        <i class="material-icons">settings</i> VPN Credentials Settings </a>   
                    </div>
                </div>

                
                <a class="list-group-item list-group-item-action " href="extra_app_settings.php">
                    <i class="material-icons">apps</i> Extra App</a>
                <a class="list-group-item list-group-item-action " href="landing_page.php">
                    <i class="material-icons">web</i> Landing Page</a>
                <a class="list-group-item list-group-item-action " href="developer_options.php">
                    <i class="material-icons">developer_mode</i> Developer Options</a>
                <a class="list-group-item list-group-item-action " href="user.php">
                    <i class="material-icons">manage_accounts</i> Update Credentials </a>

                <hr>


                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle" href="#" role="button"
                        id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">handyman</i> Useful Tools</a>

                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">

                        <a class="list-group-item list-group-item-action " href="https://imgbb.com/">
                            <i class="material-icons">upload</i> Upload Images </a>
                        <a class="list-group-item list-group-item-action "
                            href="https://davinci.rtxrebrands.com/rimage.php">
                            <i class="material-icons">rounded_corner</i> Image Rounded Corners</a>
                        <a class="list-group-item list-group-item-action "
                            href="https://davinci.rtxrebrands.com/rcrop.php">
                            <i class="material-icons">crop</i> Image Rounded Crop </a>
                        <a class="list-group-item list-group-item-action "
                            href="https://realfavicongenerator.net">
                            <i class="material-icons">eco</i> Favicon Generator </a>   
                        <a class="list-group-item list-group-item-action "
                            href="https://icon.kitchen">
                            <i class="material-icons">cruelty_free</i> App Icon Generator </a>    

                    </div>
                </div>

            </div>
        </div>
        <div id="page-content-wrapper">
         <nav class="navbar navbar-expand-lg navbar-dark ctnav">
             <button class="btn btn-primary" id="menu-toggle"><i class="material-icons">menu</i></button>
             <div class="center" id="pageMessages"></div>
             <a href="<?=basename($_SERVER["SCRIPT_NAME"]).'?logout'?>" class="btn btn-danger ml-auto mr-1"><i class="material-icons">logout</i> Logout</a> 
         </nav>
         <div class="container-fluid">
         <br>
     <style>
body{background-color: #181828;background-image: url("./img/binding_dark.webp"); color: #fff;}
#particles-js{background-size: cover; background-position: 50% 50%; background-repeat: no-repeat; background: #8000FF; display: flex; justify-content: center; align-items: center;}
.particles-js-canvas-el{position: fixed;}
#pageMessages {left: 50%; transform: translateX(-50%); position: fixed; text-align: center; top: 5px; width: 60%; z-index: 9999; border-radius: 0px;}
.alert {position: relative;}
.alert .close {position: absolute; top: 5px; right: 5px; font-size: 1em;}
.alert .material-icons {margin-right: .3em;}
.material-icons {vertical-align: middle; font-size: 24px;}
     </style>
        <script src="./js/custom.js"></script>
        <script src="./js/three.min.js"></script>
        <script src="./js/vanta.net.min.js"></script>
   </body>
</html>
