<?php 
include ('includes/json_utils.php');
include ('includes/header.php');

$page_name = 'backdrip_image';
$table_name = 'bdimage';

// Insert initial data if the table is empty
$data = ['link' => 'https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg'];
$db->insertIfEmpty($table_name, $data);

// Retrieve the existing data for display
$res = $db->select($table_name, '*', '', '');

// Handle form submission
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
}


function getCurrentDateTimeMd5() {
  $dateTime = date('Y-m-d H:i:s');
  $md5Hash = md5($dateTime);
  return $md5Hash;
}


?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Backdrop image</h2>
                </center>
            </div>
            
            <div class="card-body">
                <form method="post">
                    
                    <div class="form-group ctinput">
                        <label class="form-label"> Image link :</label>
                        <div class="form-group ctinput">
                            <input class="form-control" id="link" name="link" value="<?php echo $res[0]['link']?>"
                                placeholder="Eg: https://c4.wallpaperflare.com/wallpaper/wallpaper-preview.jpg" type="text" />
                        </div>
                    </div>

                    <div class="form-group ctinput">
                            <label class="form-label">Image Preview:</label>
                            <div>
                                <img id="imagePreview" src="<?php echo htmlspecialchars($res[0]['link']); ?>" 
                                     alt="Image Preview" style="max-width: 300px; max-height: 300px; display: <?php echo $res[0]['link'] ? 'block' : 'none'; ?>;" 
                                     onerror="this.style.display='none'; document.getElementById('previewError').style.display='block';" />
                                <p id="previewError" style="color: red; display: <?php echo $res[0]['link'] ? 'none' : 'block'; ?>;">
                                    No valid image to display
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Update
                            </button>
                        </center>
                    </div>
                </form>
            </div>       
        </div>
    </div>
</div>
<?php include ('includes/footer.php');?>
