<?php
header('Content-Type: text/html; charset=UTF-8');

$name = $_GET['name'] ?? 'RTX Rebrand';


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RTX Rebrand Animation</title>
    <style>
        /* Converted SCSS to CSS */
        .text {
            fill: none;
            stroke-width: 3;
            stroke-linejoin: round;
            stroke-dasharray: 70 360;
            stroke-dashoffset: 0;
            animation: stroke 6s infinite linear;
        }

        .text:nth-child(5n + 1) {
            stroke: #f2385a;
            animation-delay: -1.2s;
        }

        .text:nth-child(5n + 2) {
            stroke: #f5a503;
            animation-delay: -2.4s;
        }

        .text:nth-child(5n + 3) {
            stroke: #e9f1df;
            animation-delay: -3.6s;
        }

        .text:nth-child(5n + 4) {
            stroke: #56d9cd;
            animation-delay: -4.8s;
        }

        .text:nth-child(5n + 5) {
            stroke: #3aa1bf;
            animation-delay: -6s;
        }

        @keyframes stroke {
            100% {
                stroke-dashoffset: -400;
            }
        }

        /* Other styles */
        html,
        body {
            height: 100%;
            margin: 0;
        }

        body {
            background: #111;
            background-size: 0.2em 100%;
            font: 5em/1 'Open Sans', Impact;
            text-transform: uppercase;
        }

        svg {
            position: absolute;
            width: 100%;
            height: 100%;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:800" rel="stylesheet">
</head>
<body>
    <svg viewBox="0 0 600 300">
        <!-- Symbol -->
        <symbol id="s-text">
            <text text-anchor="middle" x="50%" y="50%" dy=".35em">
                <?php echo htmlspecialchars($name); ?>
            </text>
        </symbol>
        <!-- Duplicate symbols -->
        <use class="text" xlink:href="#s-text"></use>
        <use class="text" xlink:href="#s-text"></use>
        <use class="text" xlink:href="#s-text"></use>
        <use class="text" xlink:href="#s-text"></use>
        <use class="text" xlink:href="#s-text"></use>
    </svg>
</body>
</html>