<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Image Slideshow</title>
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            overflow: hidden;
        }
        .slideshow-container {
            position: relative;
            width: 100%;
            height: 100%;
        }
        .slides {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }
        .slides img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .slides.show {
            opacity: 1;
        }
    </style>
</head>
<body>

<?php
session_start();
error_reporting(0);
$db = new SQLite3('./.db.db');
$res = $db->query('SELECT * FROM menuads'); 
$json_response = array(); 
    
while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
    $row_array = array();
    $row_array['title'] = $row['title']; 
    $row_array['url'] = $row['url']; 
    array_push($json_response, $row_array);  
}


if(empty($json_response)) {
    $arrayVar = [
        [
            "title" => "AdsX",
            "url" => "https://c1.wallpaperflare.com/preview/382/354/499/welcome-lettering-typography-neon-font.jpg",
        ],
        [
            "title" => "Ads2",
            "url" => "https://c1.wallpaperflare.com/preview/917/971/718/welcome-lettering-typography-neon-font.jpg",
        ],
    ];
    
    $final = json_encode($arrayVar, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} else {
    $final = json_encode($json_response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}

$images = json_decode($final, true);

?>

<div class="slideshow-container">
    <?php
    foreach ($images as $index => $image) {
        echo '<div class="slides">';
        echo '<img src="'.$image['url'].'" alt="'.$image['title'].'">';
        echo '</div>';
    }
    ?>
</div>

<script>
    let slideIndex = 0;
    showSlides();

    function showSlides() {
        let i;
        let slides = document.getElementsByClassName("slides");
        for (i = 0; i < slides.length; i++) {
            slides[i].classList.remove("show");
        }
        slideIndex++;
        if (slideIndex > slides.length) {slideIndex = 1}
        slides[slideIndex - 1].classList.add("show");
        setTimeout(showSlides, 7000); // Change image every 5 seconds
    }
</script>

</body>
</html>
