<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoodtwarzanie Tła z Polskimi Okładkami DVD</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            background-color: #000;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            display: flex;
            align-items: center;
            position: relative;
        }
        #backdrop {
            width: 80vw; /* Adjust width of the backdrop */
            height: 100vh; /* Adjust height of the backdrop */
            object-fit: cover;
        }
        .dvd-cover-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.5);
            border-radius: 5px;
        }
        .dvd-cover {
            max-width: 100px; /* Adjust size of the DVD cover as needed */
            margin-bottom: 10px;
        }
        .movie-info {
            font-size: 0.5em;
            text-align: center;
            color: #fff;
        }
        .movie-title {
            font-size: 1.5em;
            margin-bottom: 5px;
            color: orange; /* Change the title color to yellow */
        }
        .movie-rating {
            font-size: 1em;
            color: yellow; /* Change the title color to yellow */
        }
    </style>
</head>
<body>
    <div class="container">
        <img id="backdrop">
        <div class="dvd-cover-container">
            <img id="dvd-cover" class="dvd-cover">
            <div class="movie-info">
                <div id="movie-title" class="movie-title"></div>
                <div id="movie-overview" class="movie-overview"></div>
                <div id="movie-rating" class="movie-rating"></div>
            </div>
        </div>
    </div>

    <script>
        // Fetch the API key from the server
        fetch('tmdbkey.json')
            .then(response => response.json())
            .then(data => {
                const apiKey = data.tmdbkey;
                const language =  data.tmdlng;


                let currentIndex = 0;
                let movieIds = [];

                async function fetchPopularPolishMovieIds() {
                    try {
                        const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en`);
                        if (!response.ok) {
                            throw new Error('Nie udało się pobrać popularnych polskich filmów');
                        }
                        const data = await response.json();
                        movieIds = data.results.map(movie => movie.id);
                    } catch (error) {
                        console.error('Błąd podczas pobierania popularnych polskich filmów:', error);
                    }
                }

                async function fetchMovieBackdrop(movieId) {
                    try {
                        const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                        if (!response.ok) {
                            throw new Error('Nie udało się pobrać tła filmu');
                        }
                        const data = await response.json();
                        const backdropPath = data.backdrops[0].file_path; // Assuming the first backdrop in the array
                        return `https://image.tmdb.org/t/p/original${backdropPath}`;
                    } catch (error) {
                        console.error('Błąd podczas pobierania tła filmu:', error);
                    }
                }

                async function fetchMovieCover(movieId) {
                    try {
                        const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                        if (!response.ok) {
                            throw new Error('Nie udało się pobrać okładki DVD filmu');
                        }
                        const data = await response.json();
                        const posterPath = data.poster_path;
                        return `https://image.tmdb.org/t/p/w500${posterPath}`;
                    } catch (error) {
                        console.error('Błąd podczas pobierania okładki DVD filmu:', error);
                    }
                }
                
                async function fetchMovieDetails(movieId) {
                    try {
                        const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                        if (!response.ok) {
                            throw new Error('Nie udało się pobrać szczegółów filmu');
                        }
                        const data = await response.json();
                        return {
                            title: data.title,
                            overview: data.overview,
                            rating: data.vote_average
                        };
                    } catch (error) {
                        console.error('Błąd podczas pobierania szczegółów filmu:', error);
                        return {
                            title: 'Nieznany',
                            overview: 'Brak opisu dostępnego.',
                            rating: 'N/A'
                        };
                    }
                }

                async function updateBackdropAndCover() {
                    if (movieIds.length === 0) {
                        console.error('Brak dostępnych ID filmów.');
                        return;
                    }

                    const movieId = movieIds[currentIndex];

                    try {
                        const backdropUrl = await fetchMovieBackdrop(movieId);
                        if (backdropUrl) {
                            const backdrop = document.getElementById('backdrop');
                            backdrop.src = backdropUrl;
                        }

                        const coverUrl = await fetchMovieCover(movieId);
                        if (coverUrl) {
                            const cover = document.getElementById('dvd-cover');
                            cover.src = coverUrl;
                        }

                        const { title, overview, rating } = await fetchMovieDetails(movieId);
                        const movieTitle = document.getElementById('movie-title');
                        const movieOverview = document.getElementById('movie-overview');
                        const movieRating = document.getElementById('movie-rating');
                        movieTitle.textContent = title;
                        movieOverview.textContent = overview;
                        movieRating.textContent = `Ocena: ${rating}/10`;

                        currentIndex = (currentIndex + 1) % movieIds.length;
                    } catch (error) {
                        console.error('Błąd podczas aktualizacji tła, okładki i szczegółów filmu:', error);
                    }
                }

                fetchPopularPolishMovieIds().then(() => {
                    setInterval(updateBackdropAndCover, 8000); // Change backdrop, cover, and movie details every 8 seconds (adjust as needed)
                    updateBackdropAndCover(); // Initial update
                });
            })
            .catch(error => {
                console.error('Błąd podczas pobierania klucza API:', error);
            });
    </script>
</body>
</html>
