<?php 
include ('includes/header.php');
$table_name = 'credentials';
$page_name = 'vpn_credentials_settings';

// Insert initial data if the table is empty
$data = ['visibal' => 'hide', 'type' => 'onlypass'];
$db->insertIfEmpty($table_name, $data);

// Retrieve the existing data for display
$res = $db->select($table_name, '*', '', '');

// Handle form submission
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
}

// Set default values for form fields based on current database values
$visi = $res[0]['visibal'] ?? 'hide';
$type = $res[0]['type'] ?? 'onlypass';
?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> VPN Credentials Settings</h2>
                </center>
            </div>
            
            <div class="card-body">
                <form method="post">
                    <div class="form-group ctinput">
                        <label class="form-label">Should credentials be shown to the user?
 </label>
                        <select id="visibal" name="visibal">
                            <option value="show" <?= $visi == 'show' ? 'selected' : '' ?>>Show</option>
                            <option value="hide" <?= $visi == 'hide' ? 'selected' : '' ?>>Hide</option>
                        </select>
                    </div>
                    <div class="form-group ctinput">
                        <label class="form-label">How to connect </label>
                        <select id="type" name="type">
                            <option value="not" <?= $type == 'not' ? 'selected' : '' ?>>Do nothing</option>
                            <option value="onlypass" <?= $type == 'onlypass' ? 'selected' : '' ?>>Autofill in the credentials</option>
                            <option value="passandc" <?= $type == 'passandc' ? 'selected' : '' ?>>Autofill credentials and connect</option>
                        </select>
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include ('includes/footer.php');?>
