<?php
include(__DIR__ . '/../includes/functions.php');
$pop = $db->select('pop', '*', 'id = :id', '', [':id' => 1]);
$link = $pop[0]['link'] ?? 'https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg';
$link = htmlspecialchars($link, ENT_QUOTES, 'UTF-8');
if (!filter_var($link, FILTER_VALIDATE_URL)) {
    $link = 'https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Image Glitch Effect</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      height: 100vh;
      width: 100vw;
      overflow: hidden;
      display: flex;
      justify-content: center;
      align-items: center;
      background-color: #000;
    }
    .container {
      position: relative;
      width: 100%;
      height: 100%;
    }
    .background-image {
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
      object-fit: cover;
      filter: blur(10px);
      opacity: 0.8;
      z-index: 1;
      animation: zoomInOut 10s ease-in-out infinite;
    }
    .gradient-overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100vw; height: 100vh;
      z-index: 2;
      pointer-events: none;
    }

    .foreground-image {
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
      object-fit: contain;
      z-index: 3;
   
    }

    .foreground-image-rgb {
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
      object-fit: contain;
      z-index: 4;
      mix-blend-mode: screen;
      opacity: 0.4;
      animation: rgbShift 3s infinite ease-in-out;
    }

    @keyframes zoomInOut {
      0% { transform: scale(1); }
      50% { transform: scale(1.2); }
      100% { transform: scale(1); }
    }

    @keyframes glitch {
      0%, 100% {
        transform: none;
        clip-path: inset(0% 0% 0% 0%);
        opacity: 1;
      }
      10% {
        transform: skew(0.5deg, -0.5deg);
        clip-path: inset(10% 0% 85% 0%);
        opacity: 0.8;
      }
      20% {
        transform: skew(-1deg, 1deg) scale(1.02);
        clip-path: inset(20% 0% 70% 0%);
      }
      40% {
        transform: translateX(5px);
        clip-path: inset(40% 0% 50% 0%);
        opacity: 0.9;
      }
      60% {
        transform: skew(0.5deg, 0.5deg);
        clip-path: inset(60% 0% 20% 0%);
      }
      80% {
        transform: translateX(-5px);
        clip-path: inset(80% 0% 10% 0%);
        opacity: 0.9;
      }
    }

    @keyframes rgbShift {
      0% {
        filter: drop-shadow(0px 0px 0 red) drop-shadow(0px 0px 0 blue);
      }
      25% {
        filter: drop-shadow(-2px 0px 0 red) drop-shadow(2px 0px 0 blue);
      }
      50% {
        filter: drop-shadow(0px 0px 0 red) drop-shadow(0px 0px 0 blue);
      }
      75% {
        filter: drop-shadow(2px 0px 0 red) drop-shadow(-2px 0px 0 blue);
      }
      100% {
        filter: drop-shadow(0px 0px 0 red) drop-shadow(0px 0px 0 blue);
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <img class="background-image" src="<?php echo $link; ?>" alt="Blurred Background" onerror="this.src='https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg';">
    <div class="gradient-overlay"></div>
    <img class="foreground-image" src="<?php echo $link; ?>" alt="Foreground Image" onerror="this.src='https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg';">
    <img class="foreground-image-rgb" src="<?php echo $link; ?>" alt="RGB Overlay" onerror="this.src='https://c1.wallpaperflare.com/preview/235/277/174/hyacinth-flower-fragrant-flower-fragrant.jpg';">
  </div>
</body>
</html>
