<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoplaying Backdrops with Polish Posters</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        #backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .movie-container {
            position: relative;
            z-index: 1;
            width: calc(400px + 10%); /* Zwiększa szerokość kontenera o 10% */
            padding: 10px;
            background-color: rgba(0, 0, 0, 0.5);
            border-radius: 5px;
            color: #fff;
            display: flex;
            flex-direction: row;
            align-items: flex-start; /* Wyrównaj elementy do górnej krawędzi */
            border: 2px solid transparent; /* Początkowo przezroczyste obramowanie */
            margin: 10px;
            transition: border 0.3s ease-in-out, box-shadow 0.3s ease-in-out; /* Płynna zmiana obramowania i efektu podświetlenia */
        }
        .movie-container-highlight {
            border: 2px solid green; /* Kolor podświetlenia obramowania */
            box-shadow: 0 0 10px green; /* Efekt podświetlenia (glow) */
        }
        .movie-info {
            flex: 1;
            font-size: 10px;
            line-height: 1.4;
            margin-right: 10px; /* Odstęp między opisem a plakatem */
        }
        .movie-title {
            color: orange;
            font-size: 14px;
        }
        .release-year {
            color: red;
            font-weight: bold;
        }
        .poster {
            max-width: 127.5px; /* Zmniejszona szerokość plakatu o 15% z 150px do 127.5px */
            border-radius: 5px;
            display: block;
            border: 3px solid transparent; /* Początkowo przezroczyste obramowanie */
            margin: 10px 0;
            transition: border 0.3s ease-in-out; /* Płynna zmiana obramowania */
        }
        .poster-highlight {
            border: 3px solid green; /* Kolor podświetlenia obramowania */
            box-shadow: 0 0 10px green; /* Efekt podświetlenia (glow) */
        }
    </style>
</head>
<body>
<?php
    $jsonData = file_get_contents('tmdbkey.json');
    $data = json_decode($jsonData, true);
    if ($data !== null) {
        $tmdbkey = $data['tmdbkey'];
        $tmdblanguage = $data['tmdlng'];
    }
?>    
    <img id="backdrop">
    <div class="movie-container" id="movie-container">
        <div class="movie-info" id="movie-info"></div>
        <img id="poster" class="poster">
    </div>

    <script>
        const apiKey = "<?php echo $tmdbkey; ?>"; // Zastąp swoim kluczem API TMDb
        const language =  "<?php echo $tmdblanguage; ?>";
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularPolishMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać popularnych polskich filmów');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Błąd przy pobieraniu popularnych polskich filmów:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać tła filmu');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0].file_path; // Zakładając, że pierwsze tło w tablicy
                return `https://image.tmdb.org/t/p/original${backdropPath}`;
            } catch (error) {
                console.error('Błąd przy pobieraniu tła filmu:', error);
            }
        }

        async function fetchMoviePoster(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać plakatu filmu');
                }
                const data = await response.json();
                const poster = data.posters.find(p => p.iso_639_1 === {language}); // Filtruj plakaty w języku polskim
                const posterPath = poster ? poster.file_path : data.posters[0].file_path; // Domyślnie pierwszy plakat, jeśli brak wersji polskiej
                return `https://image.tmdb.org/t/p/w500${posterPath}`;
            } catch (error) {
                console.error('Błąd przy pobieraniu plakatu filmu:', error);
            }
        }

        async function fetchMovieInfo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                if (!response.ok) {
                    throw new Error('Nie udało się pobrać informacji o filmie');
                }
                const data = await response.json();
                return {
                    title: data.title,
                    releaseDate: data.release_date,
                    overview: data.overview
                };
            } catch (error) {
                console.error('Błąd przy pobieraniu informacji o filmie:', error);
            }
        }

        async function updateBackdropAndPoster() {
            if (movieIds.length === 0) {
                console.error('Brak dostępnych ID filmów.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const backdropUrl = await fetchMovieBackdrop(movieId);
                if (backdropUrl) {
                    const backdrop = document.getElementById('backdrop');
                    backdrop.src = backdropUrl;
                }

                const posterUrl = await fetchMoviePoster(movieId);
                if (posterUrl) {
                    const poster = document.getElementById('poster');
                    poster.src = posterUrl;
                    poster.classList.add('poster-highlight'); // Dodanie klasy z efektem podświetlenia
                }

                const movieInfo = await fetchMovieInfo(movieId);
                if (movieInfo) {
                    const movieInfoElement = document.getElementById('movie-info');
                    movieInfoElement.innerHTML = `
                        <strong class="movie-title">${movieInfo.title}</strong> <span class="release-year">(${movieInfo.releaseDate.substring(0, 4)})</span><br>
                        ${movieInfo.overview}
                    `;
                }

                const movieContainer = document.getElementById('movie-container');
                movieContainer.classList.add('movie-container-highlight'); // Dodanie klasy z efektem podświetlenia

                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Błąd przy aktualizacji tła i plakatu filmu:', error);
            }
        }

        fetchPopularPolishMovieIds().then(() => {
            setInterval(updateBackdropAndPoster, 6000); // Zmiana tła i plakatu co 6 sekund
            updateBackdropAndPoster(); // Początkowa aktualizacja
        });
    </script>
</body>
</html>
