<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoplaying Logos with Movie Info</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .backdrop-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1; /* Ensure backdrop is behind other elements */
        }
        .backdrop {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .poster-container {
            position: absolute;
            top: 20px;
            left: 20px;
            z-index: 1;
            padding: 10px;
            background-color: rgba(0, 0, 0, 0.5);
            border-radius: 5px;
            color: #fff;
            max-width: 300px;
            text-align: center;
        }
        .poster {
            max-width: 200px;
            margin-bottom: 10px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 10px;
        }
        .movie-info {
            font-size: 14px;
        }
    </style>
</head>
<body>
<?php
    $jsonData = file_get_contents('tmdbkey.json');
    $data = json_decode($jsonData, true);
    if ($data !== null) {
        $tmdbkey = $data['tmdbkey'];
        $tmdblanguage = $data['tmdlng'];
    }
?>    
    <div class="backdrop-container">
        <img id="backdrop" class="backdrop">
    </div>
    <div class="poster-container">
        <img id="poster" class="poster">
        <img id="logo" class="logo">
        <div id="movie-info" class="movie-info"></div>
    </div>

    <script>
        const apiKey = "<?php echo $tmdbkey; ?>";
        const language =  "<?php echo $tmdblanguage; ?>";
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularEnglishMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=${language}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch popular English movies');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Error fetching popular English movies:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie backdrop');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0].file_path; // Assuming the first backdrop in the array
                return `https://image.tmdb.org/t/p/original${backdropPath}`;
            } catch (error) {
                console.error('Error fetching movie backdrop:', error);
            }
        }

        async function fetchMoviePoster(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie poster');
                }
                const data = await response.json();
                return `https://image.tmdb.org/t/p/w300${data.poster_path}`;
            } catch (error) {
                console.error('Error fetching movie poster:', error);
            }
        }

        async function fetchMovieLogo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&append_to_response=images`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie logo');
                }
                const data = await response.json();
                const logos = data.images.logos;
                const englishLogo = logos.find(logo => logo.iso_639_1 === {language});
                if (englishLogo) {
                    return `https://image.tmdb.org/t/p/w500${englishLogo.file_path}`;
                } else {
                    return null;
                }
            } catch (error) {
                console.error('Error fetching movie logo:', error);
            }
        }

        async function fetchMovieInfo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=${language}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie info');
                }
                const data = await response.json();
                return {
                    title: data.title,
                    releaseDate: data.release_date,
                    overview: data.overview
                };
            } catch (error) {
                console.error('Error fetching movie info:', error);
            }
        }

        async function updateBackdropPosterLogoAndInfo() {
            if (movieIds.length === 0) {
                console.error('No movie IDs available.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const backdropUrl = await fetchMovieBackdrop(movieId);
                if (backdropUrl) {
                    const backdrop = document.getElementById('backdrop');
                    backdrop.src = backdropUrl;
                }

                const posterUrl = await fetchMoviePoster(movieId);
                if (posterUrl) {
                    const poster = document.getElementById('poster');
                    poster.src = posterUrl;
                }

                const logoUrl = await fetchMovieLogo(movieId);
                if (logoUrl) {
                    const logo = document.getElementById('logo');
                    logo.src = logoUrl;
                }

                const movieInfo = await fetchMovieInfo(movieId);
                if (movieInfo) {
                    const movieInfoElement = document.getElementById('movie-info');
                    movieInfoElement.innerHTML = `
                        <strong>${movieInfo.title}</strong> (${movieInfo.releaseDate.substring(0, 4)})<br>
                        ${movieInfo.overview}
                    `;
                }

                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Error updating backdrop, poster, logo, and movie info:', error);
            }
        }

        fetchPopularEnglishMovieIds().then(() => {
            setInterval(updateBackdropPosterLogoAndInfo, 6000); // Change backdrop, poster, logo, and movie info every 6 seconds (adjust as needed)
            updateBackdropPosterLogoAndInfo(); // Initial update
        });
    </script>
</body>
</html>
