<?php
include('includes/functions.php');
$table_name = "user";

$log_check = $db->select($table_name, '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
    header("Location: main.php");
    exit;
}

$data = ['id' => '1','username' => 'admin','password' => 'admin',];
$db->insertIfEmpty($table_name, $data);

$show_error = false;
if (isset($_POST["login"])){
	$username = $_POST["username"];
	$userData = $db->select($table_name, '*', 'username = :username', '', [':username' => $username]);
	if ($userData) {
		$storedPassword = $userData[0]['password'];
		$enteredPassword = $_POST["password"];
		if ($enteredPassword == $storedPassword) {
			session_regenerate_id();
			$_SESSION['loggedin'] = TRUE;
			$_SESSION['name'] = $_POST['username'];
			if ($_POST['username'] == 'admin'){
				header('Location: user.php');
			}else{
				header('Location: main.php');
			}
		}else{
			$show_error = true;
		}
	}else{
		$show_error = true;
	}
	$db->close();
}

// Version pour le cache
$cache_version = "2";
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="author" content="FTG">
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <title>SmartersManager</title>
    
    <!-- FAVICON AJOUTÉE ICI -->
    <link rel="icon" type="image/x-icon" href="./img/favicon.ico?version=<?php echo $cache_version; ?>">
    <link rel="icon" type="image/png" href="./img/favicon.png?version=<?php echo $cache_version; ?>">
    <link rel="apple-touch-icon" href="./img/apple-touch-icon.png?version=<?php echo $cache_version; ?>">
    
    <!-- Désactiver le cache -->
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
<style>
/* [VOTRE CSS EXISTANT - Même que précédemment] */
body {
  margin: 0;
  padding: 0;
  background-color: #232331;
  color: #ffffff;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  overflow-x: hidden;
}

.background-container {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: -1;
  overflow: hidden;
}

.bg-overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: linear-gradient(135deg, rgba(0, 230, 199, 0.1) 0%, rgba(30, 30, 50, 0.3) 100%);
  opacity: 0.4;
}

.particles-js-canvas-el {
  position: absolute;
  top: 0;
  left: 0;
}

.login-container {
  background-color: #2c2c3a;
  border-radius: 15px;
  padding: 30px;
  box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(0, 230, 199, 0.1);
  max-width: 400px;
  margin: 0 auto;
  transform: translateY(20px);
  animation: fadeIn 1s ease-out forwards;
}

@keyframes fadeIn {
  from {
    opacity: 0;
    transform: translateY(40px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

.logo-container {
  text-align: center;
  margin-bottom: 20px;
  animation: pulse 3s infinite ease-in-out;
}

.logo-container img {
  max-width: 180px;
  filter: drop-shadow(0 5px 15px rgba(0, 230, 199, 0.3));
  transition: all 0.3s ease;
}

@keyframes pulse {
  0% {
    transform: scale(1);
  }
  50% {
    transform: scale(1.05);
  }
  100% {
    transform: scale(1);
  }
}

.logo-container img:hover {
  transform: scale(1.05);
}

.form-control {
  background-color: rgba(30, 30, 50, 0.5);
  border: 1px solid rgba(0, 230, 199, 0.2);
  border-radius: 8px;
  color: #ffffff;
  padding: 12px 15px;
  height: auto;
  transition: all 0.3s ease;
}

.form-control:focus {
  background-color: rgba(40, 40, 60, 0.7);
  border-color: #00e6c7;
  box-shadow: 0 0 10px rgba(0, 230, 199, 0.3);
  color: #ffffff;
}

.input-group {
  margin-bottom: 20px;
}

.input-group-prepend .input-group-text {
  background-color: rgba(20, 20, 40, 0.8);
  border: 1px solid rgba(0, 230, 199, 0.2);
  border-right: none;
  border-radius: 8px 0 0 8px;
  color: #00e6c7;
}

.form-control {
  border-left: none;
  border-radius: 0 8px 8px 0;
}

.btn-login {
  background: linear-gradient(45deg, #00cca6, #00e6c7);
  border: none;
  border-radius: 8px;
  color: #232331;
  font-weight: 600;
  letter-spacing: 1px;
  padding: 12px;
  text-transform: uppercase;
  transition: all 0.3s ease;
  box-shadow: 0 5px 15px rgba(0, 230, 199, 0.4);
}

.btn-login:hover {
  background: linear-gradient(45deg, #00e6c7, #00cca6);
  transform: translateY(-2px);
  box-shadow: 0 7px 20px rgba(0, 230, 199, 0.6);
}

.btn-login:active {
  transform: translateY(1px);
}

.text-credits {
  margin-top: 25px;
  font-size: 0.9rem;
  color: rgba(255, 255, 255, 0.7);
  text-align: center;
}

.text-credits a {
  color: #00e6c7;
  text-decoration: none;
  transition: color 0.3s ease;
}

.text-credits a:hover {
  color: #00cca6;
  text-decoration: none;
}

.movie-elements {
  position: absolute;
  width: 100%;
  height: 100%;
  overflow: hidden;
  z-index: -1;
}

.movie-element {
  position: absolute;
  opacity: 0.1;
  filter: blur(1px);
  transition: all 15s linear;
  color: #00e6c7;
}

.element-1 {
  top: 10%;
  left: 5%;
  animation: float 20s infinite alternate ease-in-out;
}

.element-2 {
  bottom: 15%;
  right: 10%;
  animation: float 25s infinite alternate-reverse ease-in-out;
}

.element-3 {
  top: 45%;
  right: 20%;
  animation: float 18s infinite alternate ease-in-out;
}

.element-4 {
  bottom: 30%;
  left: 15%;
  animation: float 22s infinite alternate-reverse ease-in-out;
}

@keyframes float {
  0% {
    transform: translate(0, 0) rotate(0deg);
  }
  50% {
    transform: translate(20px, 20px) rotate(5deg);
  }
  100% {
    transform: translate(-20px, 10px) rotate(-5deg);
  }
}

.expiration-info {
  text-align: center;
  margin-top: 20px;
  font-size: 0.9rem;
  color: rgba(255, 255, 255, 0.7);
}

.title-accent {
  color: #00e6c7;
}

/* Media Query for mobile devices */
@media (max-width: 767px) {
  .login-container {
    margin: 0 15px;
  }
}

/* Styles pour la popup d'erreur */
.error-popup {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.8);
  z-index: 9999;
  align-items: center;
  justify-content: center;
}

.error-popup.show {
  display: flex;
}

.error-popup-content {
  background: linear-gradient(135deg, #2c2c3a 0%, #232331 100%);
  padding: 30px;
  border-radius: 15px;
  text-align: center;
  max-width: 400px;
  width: 90%;
  box-shadow: 0 5px 20px rgba(5, 227, 131, 0.7);
  animation: popupShow 0.4s ease;
  border: 1px solid #00e6c7;
  backdrop-filter: blur(10px);
}

.error-popup-icon {
  font-size: 48px;
  color: #f10707;
  margin-bottom: 15px;
}

.error-popup-title {
  color: #00e6c7;
  font-size: 22px;
  font-weight: 600;
  margin-bottom: 10px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.error-popup-message {
  color: #ffffff;
  font-size: 16px;
  margin-bottom: 25px;
  line-height: 1.4;
}

.error-popup-btn {
  background: linear-gradient(45deg, #ff0202, #ff0202);
  color: white;
  border: none;
  border-radius: 8px;
  padding: 12px 30px;
  font-size: 16px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.3s ease;
  text-transform: uppercase;
  letter-spacing: 1px;
  box-shadow: 0 5px 15px rgba(0, 230, 199, 0.4);
}

.error-popup-btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 20px rgba(255, 107, 107, 0.6);
  background: #00cca6;
}

@keyframes popupShow {
  from {
    opacity: 0;
    transform: scale(0.8) translateY(-20px);
  }
  to {
    opacity: 1;
    transform: scale(1) translateY(0);
  }
}

@keyframes shake {
  0%, 100% { transform: translateX(0); }
  25% { transform: translateX(-10px); }
  75% { transform: translateX(10px); }
}

.shake {
  animation: shake 0.5s ease-in-out;
}

/* NOUVEAUX STYLES POUR LES BOUTONS SOCIAUX */
.social-media {
  display: flex;
  justify-content: center;
  margin: 25px 0;
  gap: 15px;
}

.social-icon {
  height: 50px;
  width: 50px;
  background: linear-gradient(-45deg, rgba(0, 0, 0, 0.8), rgba(255, 255, 255, 0.25));
  color: #10a5f9;
  font-size: 20px;
  border-radius: 50%;
  display: flex;
  justify-content: center;
  align-items: center;
  border: 3px solid rgb(26, 26, 26);
  box-shadow: 4px 4px 8px 0 rgba(9, 11, 15, 1), -4px -4px 8px 0 rgba(46, 59, 66, 0.5);
  text-decoration: none;
  transition: all 0.3s ease;
}

.social-icon:hover {
  border: 2px solid #10a5f9;
  transform: translateY(-3px);
  box-shadow: 6px 6px 12px 0 rgba(9, 11, 15, 1), -6px -6px 12px 0 rgba(46, 59, 66, 0.5);
}

/* Couleurs spécifiques pour chaque bouton */
.social-icon.whatsapp {
  color: #25d366;
}

.social-icon.download {
  color: #FF6B6B;
}

.social-icon.telegram {
  color: #0088cc;
}

.social-divider {
  display: flex;
  align-items: center;
  margin: 20px 0;
  color: rgba(255, 255, 255, 0.5);
  font-size: 14px;
}

.social-divider::before,
.social-divider::after {
  content: "";
  flex: 1;
  border-bottom: 1px solid rgba(0, 230, 199, 0.3);
}

.social-divider span {
  padding: 0 15px;
}
</style>
</head>

<body>
  <!-- Popup d'erreur -->
  <div id="errorPopup" class="error-popup <?php echo $show_error ? 'show' : ''; ?>">
    <div class="error-popup-content">
      <div class="error-popup-icon">
        <i class="fas fa-exclamation-triangle"></i>
      </div>
      <div class="error-popup-title">Erreur de Connexion</div>
      <div class="error-popup-message">
        Nom d'utilisateur ou mot de passe incorrect.<br>
        Veuillez vérifier vos identifiants et réessayer.
      </div>
      <button class="error-popup-btn" onclick="closeErrorPopup()">
        <i class="fas fa-redo mr-2"></i> Réessayer
      </button>
    </div>
  </div>

  <div class="background-container">
    <div id="js-particles"></div>
    <div class="bg-overlay"></div>
    <div class="movie-elements">
      <div class="movie-element element-1">
        <i class="fas fa-film fa-4x"></i>
      </div>
      <div class="movie-element element-2">
        <i class="fas fa-tv fa-4x"></i>
      </div>
      <div class="movie-element element-3">
        <i class="fas fa-video fa-4x"></i>
      </div>
      <div class="movie-element element-4">
        <i class="fas fa-ticket-alt fa-4x"></i>
      </div>
    </div>
  </div>

  <div class="container mt-5">
    <div class="row justify-content-center">
      <div class="col-lg-5 col-md-7 col-sm-9">
        <div class="login-container" id="loginContainer">
          <div class="logo-container">
            <img src="./img/login_logo.png?version=<?php echo $cache_version; ?>" alt="Entertainment Portal Logo" class="img-fluid">
          </div>
          <h4 class="text-center mb-4"><span class="title-accent">V4.0.5</span></h4>
          
          <form method="post">
            <div class="input-group mb-3">
              <div class="input-group-prepend">
                <span class="input-group-text"><i class="fas fa-user"></i></span>
              </div>
              <input type="text" class="form-control" placeholder="Username" name="username" required autofocus value="<?php if(isset($_POST['username'])) { echo htmlspecialchars($_POST['username']); } ?>">
            </div>
            
            <div class="input-group mb-4">
              <div class="input-group-prepend">
                <span class="input-group-text"><i class="fas fa-lock"></i></span>
              </div>
              <input type="password" class="form-control" placeholder="Password" name="password" required>
            </div>
            
            <button type="submit" class="btn btn-login btn-block" name="login">
              <i class="fas fa-sign-in-alt mr-2"></i> LOGIN
            </button>
          </form>
          
          <!-- Section réseaux sociaux avec les nouveaux boutons -->
          <div class="social-login">
            <div class="social-divider">
              <span>Or Sign in with social platform</span>
            </div>
            
            <div class="social-media">
              <a href="https://wa.link/dgnpw2" class="social-icon whatsapp" target="_blank">
                <i class="fab fa-whatsapp"></i>
              </a>
              <a href="http://aftv.news/6220061" class="social-icon download" target="_blank">
                <i class="fas fa-download"></i>
              </a>
              <a href="https://t.me/bf31_69TopStreaming" class="social-icon telegram" target="_blank">
                <i class="fab fa-telegram"></i>
              </a>
            </div>
          </div>
          
          <div class="text-credits">
            <div class="mb-2">Your gateway to unlimited entertainment</div>
            <a href="https://t.me/bf31_69TopStreaming" id="contact-link" target="_blank" class="contact-support">
              <i class="fab fa-telegram"></i> Bf31-69topStreaming
            </a> • 
            <span>© 2025 FTG Panels</span>
          </div>
          
          <div class="expiration-info">
            <i class="far fa-calendar-alt mr-1"></i> Expiration: November 27, 2026
          </div>
        </div>
      </div>
    </div>
  </div>

<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script>
// Forcer le rechargement sans cache
window.onload = function() {
    // Réinitialiser le cache des images
    var images = document.getElementsByTagName('img');
    for (var i = 0; i < images.length; i++) {
        var img = images[i];
        var src = img.src;
        if (src.indexOf('?') === -1) {
            img.src = src + '?nocache=' + new Date().getTime();
        } else {
            img.src = src + '&nocache=' + new Date().getTime();
        }
    }
};

// Gestion de la popup d'erreur
function closeErrorPopup() {
    document.getElementById('errorPopup').classList.remove('show');
    // Effet de shake sur le formulaire
    document.getElementById('loginContainer').classList.add('shake');
    setTimeout(function() {
        document.getElementById('loginContainer').classList.remove('shake');
    }, 500);
}

// Fermer la popup en cliquant à l'extérieur
document.getElementById('errorPopup').addEventListener('click', function(e) {
    if (e.target === this) {
        closeErrorPopup();
    }
});

// Fermer la popup avec la touche Echap
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeErrorPopup();
    }
});

// Afficher la popup automatiquement s'il y a une erreur PHP
<?php if ($show_error): ?>
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(function() {
        document.getElementById('errorPopup').classList.add('show');
        // Effet de shake sur le formulaire
        document.getElementById('loginContainer').classList.add('shake');
        setTimeout(function() {
            document.getElementById('loginContainer').classList.remove('shake');
        }, 500);
    }, 800);
});
<?php endif; ?>

document.addEventListener('DOMContentLoaded',function(){
    // Initialisation des particules
    if (typeof particlesJS !== 'undefined' && document.getElementById('js-particles')) {
        particlesJS('js-particles', {
            "particles": {
                "number": {
                    "value": 40,
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#00e6c7"
                },
                "shape": {
                    "type": "circle",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    },
                    "polygon": {
                        "nb_sides": 5
                    }
                },
                "opacity": {
                    "value": 0.3,
                    "random": false,
                    "anim": {
                        "enable": false,
                        "speed": 1,
                        "opacity_min": 0.1,
                        "sync": false
                    }
                },
                "size": {
                    "value": 3,
                    "random": true,
                    "anim": {
                        "enable": false,
                        "speed": 40,
                        "size_min": 0.1,
                        "sync": false
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 150,
                    "color": "#00e6c7",
                    "opacity": 0.2,
                    "width": 1
                },
                "move": {
                    "enable": true,
                    "speed": 2,
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "bounce": false,
                    "attract": {
                        "enable": false,
                        "rotateX": 600,
                        "rotateY": 1200
                    }
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable": true,
                        "mode": "grab"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    },
                    "resize": true
                },
                "modes": {
                    "grab": {
                        "distance": 140,
                        "line_linked": {
                            "opacity": 1
                        }
                    },
                    "bubble": {
                        "distance": 400,
                        "size": 40,
                        "duration": 2,
                        "opacity": 8,
                        "speed": 3
                    },
                    "repulse": {
                        "distance": 400,
                        "duration": 0.4
                    },
                    "push": {
                        "particles_nb": 4
                    },
                    "remove": {
                        "particles_nb": 2
                    }
                }
            },
            "retina_detect": true
        });
    }
});
</script>
</body>
</html>