<?php include __DIR__ . '/includes/auth_guard.php'; ?>
<!-- index.php -->
<?php 
include ('includes/header.php');


//table name
$table_name = "dns";
$page = "main.php";
$table_name_advance = "devop";
$macm = "user_manage.php";
$checkreadonly = 'readonly';

//table call
$res = $db->select($table_name, '*', '', '');

//advance option db
$advance = $db->select($table_name_advance, '*', 'id = :id', '', [':id' => 1]);
$per_read = !empty($advance[0]['eduuid']) ? $advance[0]['eduuid'] : 'disable';

if($per_read === 'disable'){
    $checkreadonly = 'readonly';
}else{
    $checkreadonly = '';
}


//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
	unset($_POST['submit']);
	$db->insert($table_name, $_POST);
	$db->close();
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

function uuidv4(): string {
    $data = random_bytes(16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40); // version 4
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80); // variant
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

?>

<?php if (isset($_GET['create'])){?>

<!-- Form Start -->
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Add New DNS</h6>
                    <form method="post">
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label">Title</label>
                            <input type="text" name="title" class="form-control" placeholder="Title">
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label">DNS ID</label>
                            <input type="text" name="uid" class="form-control" placeholder="DNS ID" value="<?=uuidv4(); ?>"  <?php echo $checkreadonly;?>>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">DNS</label>
                            <input type="text" class="form-control" name="url" placeholder="DNS">
                            <div id="emailHelp" class="form-text">Please double check your DNS/Server URL before adding
                                it. This will help reduce problems later.
                            </div>
                        </div>
                        <button type="submit" name="submit" class="btn btn-primary">Save</button>
                    </form>
            </div>
        </div>
    </div>
</div>
<!-- Form End -->

<?php }else if (isset($_GET['update'])){ ?>
    <div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Edit DNS</h6>
                    <form method="post">
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label">Title</label>
                            <input type="text" name="title" class="form-control" value="<?=$resU[0]['title'] ?>" placeholder="Title">
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label">DNS ID</label>
                            <input type="text" name="uid" class="form-control" placeholder="DNS ID" value="<?=$resU[0]['uid'] ?>" <?php echo $checkreadonly;?>>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">DNS</label>
                            <input type="text" class="form-control" name="url" value="<?=$resU[0]['url'] ?>" placeholder="DNS">
                            <div id="emailHelp" class="form-text">Please double check your DNS/Server URL before adding
                                it. This will help reduce problems later.
                            </div>
                        </div>
                        <button type="submit" name="submitU" class="btn btn-primary">Submit</button>
                    </form>
            </div>
        </div>
    </div>
</div>
<?php }else{?>

<!-- Table Start -->
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Current DNS</h6>
                    <div class="text-end">
                        <a type="button" href="./<?=$page ?>?create" class="btn btn-square btn-primary m-2"><i
                                class="fa fa-plus"></i></a>
                    </div>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>DNS</th>
                                    <th>Add Users</th>
                                    <th>Edit</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <?php foreach ($res as $row) {
							?>
                            <tbody>
                                <tr>
                                    <td><?=$row['id']; ?></a></td>
                                    <td><?=$row['title'] ?></a></td>
                                    <td><?=$row['url'] ?></td>
                                    <td><a class="btn btn-square btn-warning m-2" href="<?php echo $macm; ?>?create&uuid=<?php echo $row['uid']; ?>">
                                            <i class="fa fa-users"></i>
                                        </a></td>
                                    <td><a class="btn btn-square btn-success m-2" href="<?php echo $page; ?>?update=<?php echo $row['id']; ?>">
                                            <i class="fa fa-pencil-square-o"></i>
                                        </a></td>
                                    <td><a class="btn btn-square btn-primary m-2" href="#" data-href="<?php echo $page; ?>?delete=<?php echo $row['id']; ?>" data-bs-toggle="modal" data-bs-target="#confirm-delete">
                                            <i class="fa fa-trash"></i>
                                        </a></td>    
                                </tr>
                            </tbody>
                            <?php
							}?>
                        </table>
                    </div>


            </div>
        </div>
    </div>
</div>
<!-- Table End -->

<?php }?>
<!-- Footer Start -->
<?php include ('includes/footer.php');?>
<!-- Footer End -->
</body>

</html>