<?php
declare(strict_types=1);

/**
 * SQLite schema used by createTables() in includes/functions.php
 * - Idempotent; safe to re-run
 * - Sensible defaults
 * - UNIQUEs on natural keys
 */

$tables = [
    "user" => [
        "id"       => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "username" => "TEXT NOT NULL UNIQUE",
        "password" => "TEXT NOT NULL",
    ],

    "int" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "intro" => "TEXT NOT NULL DEFAULT 'enable'",
    ],

    "name" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "fname" => "TEXT NOT NULL DEFAULT ''",
        "parto" => "TEXT NOT NULL DEFAULT ''",
        "partt" => "TEXT NOT NULL DEFAULT ''",
    ],

    "ibof" => [
        "id"       => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "plid"     => "TEXT NOT NULL UNIQUE",
        "name"     => "TEXT NOT NULL DEFAULT ''",
        "macad"    => "TEXT NOT NULL",
        "uuid"     => "TEXT NOT NULL",
        "username" => "TEXT NOT NULL",
        "password" => "TEXT NOT NULL",
        "cdate"    => "TEXT NOT NULL",
        "udate"    => "TEXT NOT NULL",
        "mark"     => "INTEGER NOT NULL DEFAULT 0",
        "protec"   => "INTEGER NOT NULL DEFAULT 1",
    ],

    "mactb" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "name"  => "TEXT NOT NULL DEFAULT ''",
        "macad" => "TEXT NOT NULL UNIQUE",
        "expir" => "TEXT NOT NULL DEFAULT ''",
        "cdate" => "TEXT NOT NULL DEFAULT ''",
        "udate" => "TEXT NOT NULL DEFAULT ''",
        "blok"  => "INTEGER NOT NULL DEFAULT 0",
    ],

    "noti" => [
        "id"      => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "tital"   => "TEXT NOT NULL DEFAULT 'TiVi PLAYER doesnt sell playlists or subscriptions'",
        "content" => "TEXT NOT NULL DEFAULT 'Disclaimer: TiVi PLAYER is a general media player and it does not include any content. You have to provide your own content. TiVi PLAYER is not responsible for the content you use in the app'",
    ],

    "themes" => [
        "id"      => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "themeid" => "TEXT NOT NULL DEFAULT '1'",
    ],

    "spapi" => [
        "id"     => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "apikey" => "TEXT NOT NULL DEFAULT ''",
    ],

    "dns" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "title" => "TEXT NOT NULL DEFAULT ''",
        "url"   => "TEXT NOT NULL DEFAULT ''",
        "uid"   => "TEXT NOT NULL UNIQUE",
    ],

    "sort" => [
        "id"  => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "sort"=> "TEXT NOT NULL DEFAULT 'def'",
    ],

    "sortm" => [
        "id"  => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "sort"=> "TEXT NOT NULL DEFAULT 'def'",
    ],

    "actreq" => [
        "id"     => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "mac"    => "TEXT NOT NULL DEFAULT ''",
        "date"   => "TEXT NOT NULL DEFAULT ''",
        "remark" => "TEXT NOT NULL DEFAULT ''",
    ],

    "leaguesx" => [
        "id"       => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "league"   => "TEXT NOT NULL DEFAULT ''",
        "leagueId" => "TEXT NOT NULL DEFAULT ''",
        "lsports"  => "TEXT NOT NULL DEFAULT ''",
    ],

    "devop" => [
        "id"     => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "eduuid" => "TEXT NOT NULL DEFAULT ''",
        "maxpg"  => "TEXT NOT NULL DEFAULT '8'",
        "macmod" => "TEXT NOT NULL DEFAULT '1'",
    ],

    "demoplay" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "name"  => "TEXT NOT NULL DEFAULT ''",
        "dns"   => "TEXT NOT NULL DEFAULT ''",
        "uname" => "TEXT NOT NULL DEFAULT ''",
        "pass"  => "TEXT NOT NULL DEFAULT ''",
    ],

    "pintb" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "macad" => "TEXT NOT NULL UNIQUE",
        "pin"   => "TEXT NOT NULL DEFAULT '0000'",
    ],

    // keep legacy column name "lenth"
    "macl" => [
        "id"    => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "lenth" => "TEXT NOT NULL DEFAULT '12'",
    ],

    "plmod" => [
        "id"  => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "mod" => "TEXT NOT NULL DEFAULT '1'",
    ],

    // NEW: Google reCAPTCHA settings (single row, id=1)
    "captcha_settings" => [
        "id"         => "INTEGER PRIMARY KEY AUTOINCREMENT",
        "enabled"    => "INTEGER NOT NULL DEFAULT 0",
        "site_key"   => "TEXT NOT NULL DEFAULT ''",
        "secret_key" => "TEXT NOT NULL DEFAULT ''",
    ],
];
