<?php 
include ('includes/header.php');
include ('includes/json_utils.php');


$page_name = 'text_animation';
$table_name = "bdtextanim";

$data = ['text' => 'RTX Rebrand' , 'layout' => 'style_3' ];

$db->insertIfEmpty($table_name, $data);


$res = $db->select($table_name, '*', '', '');

if(isset($_POST['submit'])){
	unset($_POST['submit']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => 1]);
	echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
}

$textname = $res[0]['text'] ?? 'RTX Rebrand';


?>

<div class="col-md-12 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Text Animation</h2>
                </center>
            </div>

            <div class="card-body">
                <form method="post">
                    <div class="form-group ctinput">
                        <label class="form-label " for="layout">Animation Style</label>
                        <select id="layout" name="layout">
                            <option value="style_1" <?=$res[0]['layout']=='style_1'?'selected':'' ?>>Animation 1</option>
                            <option value="style_2" <?=$res[0]['layout']=='style_2'?'selected':'' ?>>Animation 2</option>
                            <option value="style_3" <?=$res[0]['layout']=='style_3'?'selected':'' ?>>Animation 3</option>
                            <option value="style_4" <?=$res[0]['layout']=='style_4'?'selected':'' ?>>Animation 4</option>
                            <option value="style_5" <?=$res[0]['layout']=='style_5'?'selected':'' ?>>Animation 5</option>
                            <option value="style_6" <?=$res[0]['layout']=='style_6'?'selected':'' ?>>Animation 6</option>
                        </select>
                    </div>

                    <div class="form-group ctinput">
                        <label class="form-label " for="dns">Animation Text</label>
                        <input class="form-control" id="text" name="text" value="<?php echo $textname; ?>"
                            placeholder="Animation Text" type="text" />
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
            <div class="grid-container">
                <div class="grid-item">
                    <iframe src="api/text/text_01.php?name=<?php echo $textname; ?>" title="Animation 1"></iframe>
                    <div class="image-text">Animation 1</div>
                </div>
                <div class="grid-item">
                    <iframe src="api/text/text_02.php?name=<?php echo $textname; ?>" title="Animation 2"></iframe>
                    <div class="image-text">Animation 2</div>
                </div>
                <div class="grid-item">
                    <iframe src="api/text/text_03.php?name=<?php echo $textname; ?>" title="Animation 3"></iframe>
                    <div class="image-text">Animation 3</div>
                </div>
                <div class="grid-item">
                    <iframe src="api/text/text_04.php?name=<?php echo $textname; ?>" title="Animation 4"></iframe>
                    <div class="image-text">Animation 4</div>
                </div>
                <div class="grid-item">
                    <iframe src="api/text/text_05.php?name=<?php echo $textname; ?>" title="Animation 5"></iframe>
                    <div class="image-text">Animation 5</div>
                </div>
                <div class="grid-item">
                    <<iframe src="api/text/text_06.php?name=<?php echo $textname; ?>" title="Animation 6"></iframe>
                        <div class="image-text">Animation 6</div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .grid-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            padding: 20px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .grid-item {
            position: relative;
            overflow: hidden;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .grid-item iframe {
            width: 100%;
            height: 300px;
            border: none;
            display: block;
        }

        .image-text {
            position: absolute;
            bottom: 0;
            width: 100%;
            background: rgba(0, 0, 0, 0.7);
            color: white;
            text-align: center;
            padding: 10px;
            font-family: sans-serif;
            font-size: 1.2em;
        }
    </style>
    <?php include ('includes/footer.php');?>