<?php 
include ('includes/header.php');
$page_name = 'tmdb_lang';
$json_file_path = 'api/ads/tmdbkey.json'; 

if(isset($_POST['submit'])){
	unset($_POST['submit']);
	$tmdblang = $_POST['tmdblag'];

    // Load existing data
    $data = [];
    if (file_exists($json_file_path)) {
        $json_data = file_get_contents($json_file_path);
        $data = json_decode($json_data, true);
    }

    // Update only the language
    $data['tmdlng'] = $tmdblang;

    // Save updated JSON
    $json_data = json_encode($data, JSON_PRETTY_PRINT);
    if (file_put_contents($json_file_path, $json_data)) {
        echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
        echo "TMDB Language saved successfully.";
    } 
}

$tmdblang = "";
if (file_exists($json_file_path)) {
    $json_data = file_get_contents($json_file_path);
    $data = json_decode($json_data, true);
    if ($data && isset($data['tmdlng'])) {
        $tmdblang = $data['tmdlng'];
    }
}

// Define top 40 TMDB languages
$tmdb_languages = [
    "en" => "English",
    "es" => "Español",
    "fr" => "Français",
    "de" => "Deutsch",
    "it" => "Italiano",
    "pt" => "Português",
    "pt-BR" => "Português (Brasil)",
    "ru" => "Русский",
    "ja" => "日本語",
    "zh" => "中文",
    "zh-CN" => "中文（简体）",
    "zh-TW" => "中文（繁體）",
    "hi" => "हिन्दी",
    "ko" => "한국어",
    "ar" => "العربية",
    "tr" => "Türkçe",
    "nl" => "Nederlands",
    "sv" => "Svenska",
    "pl" => "Polski",
    "th" => "ไทย",
    "fi" => "Suomi",
    "no" => "Norsk",
    "da" => "Dansk",
    "cs" => "Čeština",
    "ro" => "Română",
    "el" => "Ελληνικά",
    "he" => "עברית",
    "hu" => "Magyar",
    "id" => "Bahasa Indonesia",
    "ms" => "Bahasa Melayu",
    "uk" => "Українська",
    "vi" => "Tiếng Việt",
    "ta" => "தமிழ்",
    "bn" => "বাংলা",
    "fa" => "فارسی",
    "sk" => "Slovenčina",
    "sr" => "Српски",
    "hr" => "Hrvatski",
    "bg" => "Български",
    "lt" => "Lietuvių"
];
?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> TMDB Language</h2>
                </center>
            </div>
            
            <div class="card-body">
                <form method="post">
                    <div class="form-group ctinput">
                        <label class="form-label">Choose TMDB Language</label>
                        <select id="tmdblag" name="tmdblag" class="form-control">
                            <?php foreach ($tmdb_languages as $code => $name): ?>
                                <option value="<?= $code ?>" <?= ($code == $tmdblang) ? 'selected' : '' ?>>
                                    <?= $name ?> (<?= $code ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include ('includes/footer.php'); ?>
