<?php
header('Content-Type: text/html; charset=UTF-8');
$name = $_GET['name'] ?? 'RTX Rebrand';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Montserrat Animation</title>
    <style>
        html, body {
            height: 100%;
            font-weight: 800;
            margin: 0;
            padding: 0;
        }

        body {
            background: #030321;
            font-family: Arial;
        }

        .container {
            display: flex;
            height: 100%;
            align-items: center;
        }

        svg {
            display: block;
            font: 10.5em 'Montserrat';
            width: 960px;
            height: 300px;
            margin: 0 auto;
        }

        .text-copy {
            fill: none;
            stroke: white;
            stroke-dasharray: 6% 29%;
            stroke-width: 5px;
            stroke-dashoffset: 0%;
            animation: stroke-offset 5.5s infinite linear;
        }

        .text-copy:nth-child(1) {
            stroke: #4D163D;
            animation-delay: -1s;
        }

        .text-copy:nth-child(2) {
            stroke: #840037;
            animation-delay: -2s;
        }

        .text-copy:nth-child(3) {
            stroke: #BD0034;
            animation-delay: -3s;
        }

        .text-copy:nth-child(4) {
            stroke: #BD0034;
            animation-delay: -4s;
        }

        .text-copy:nth-child(5) {
            stroke: #FDB731;
            animation-delay: -5s;
        }

        @keyframes stroke-offset {
            100% {
                stroke-dashoffset: -35%;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Montserrat" rel="stylesheet">
</head>
<body>
    <div class="container">
        <svg viewBox="0 0 960 300">
            <symbol id="s-text">
                <text text-anchor="middle" x="50%" y="80%"><?php echo htmlspecialchars($name); ?></text>
            </symbol>
            <g class="g-ants">
                <use xlink:href="#s-text" class="text-copy"></use>
                <use xlink:href="#s-text" class="text-copy"></use>
                <use xlink:href="#s-text" class="text-copy"></use>
                <use xlink:href="#s-text" class="text-copy"></use>
                <use xlink:href="#s-text" class="text-copy"></use>
            </g>
        </svg>
    </div>
</body>
</html>