<?php
// Pobierz klucz API z pliku tmdbkey.json
$jsonData = file_get_contents('tmdbkey.json');
$data = json_decode($jsonData, true);
if ($data !== null) {
    $api_key = $data['tmdbkey'];
    $api_lang = $data['tmdlng'];
} else {
    die('Nie udało się odczytać klucza API.');
}

$tmdb_api_url = 'https://api.themoviedb.org/3';

function getTopMoviesThisWeek($api_key, $tmdb_api_url, $max_results = 25) {
    $top_movies_url = $tmdb_api_url . '/movie/popular?api_key=' . $api_key . '&language=' . $api_lang;
    $top_movies_json = @file_get_contents($top_movies_url);
    if ($top_movies_json === FALSE) {
        error_log("Nie udało się pobrać danych z TMDB API. URL: $top_movies_url");
        return [];
    }

    $top_movies = json_decode($top_movies_json, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Błąd dekodowania JSON: " . json_last_error_msg());
        return [];
    }

    if (!isset($top_movies['results'])) {
        error_log("Nieprawidłowa struktura odpowiedzi z TMDB API: " . print_r($top_movies, true));
        return [];
    }

    $top_movies = $top_movies['results'];
    $posters = [];
    $titles = [];
    $ratings = [];
    $descriptions = [];
    foreach ($top_movies as $movie) {
        if (count($posters) >= $max_results) {
            break;
        }
        $posters[] = $movie['poster_path'];
        $titles[] = $movie['title'];
        $ratings[] = $movie['vote_average'];
        $descriptions[] = $movie['overview'];
    }

    return ['posters' => $posters, 'titles' => $titles, 'ratings' => $ratings, 'descriptions' => $descriptions];
}

$top_data = getTopMoviesThisWeek($api_key, $tmdb_api_url);

if (empty($top_data)) {
    die('Brak danych do wyświetlenia.');
}

$top_posters = $top_data['posters'];
$top_titles = $top_data['titles'];
$top_ratings = $top_data['ratings'];
$top_descriptions = $top_data['descriptions'];
?>

<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Top Filmy Tygodnia</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            overflow: hidden;
            background: black;
            color: white;
            font-family: Arial, sans-serif;
            position: relative;
            height: 100vh;
            width: 100vw;
        }
        .container {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            position: relative;
            perspective: 1000px; /* Dodaj perspektywę dla efektu 3D */
        }
        .background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            z-index: -1; /* Tło znajduje się za kartami */
        }
        .card-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }
        .card {
            border-radius: 15px;
            overflow: hidden;
            border: 2px solid white;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);
            background: #000; /* Tło karty */
            margin: 0 20px; /* Odstęp między kartami */
            transform-style: preserve-3d; /* Zachowuje efekty 3D */
        }
        .card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .card.underlay {
            width: 147px; /* Pomniejszona szerokość karty z plakatem o 30% */
            height: 220.5px; /* Pomniejszona wysokość karty z plakatem o 30% */
            animation: rotateAround 12s linear infinite; /* Animacja obrotu */
            z-index: 1; /* Karta z plakatem znajduje się nad tłem, ale pod kartą z opisem */
        }
        .card.info {
            width: auto; /* Szerokość dostosowująca się do zawartości */
            max-width: 360px; /* Maksymalna szerokość karty z informacjami o 30% */
            height: 220.5px; /* Wysokość karty z plakatem */
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 10px;
            text-align: center;
            background: rgba(0, 0, 0, 0.5); /* 50% przezroczystości */
            overflow-y: auto; /* Dodaj przewijanie w pionie */
            overflow-x: hidden; /* Ukryj pasek przewijania w poziomie */
            z-index: 2; /* Karta z opisem znajduje się nad kartą z plakatem */
        }
        .card.info h2 {
            margin: 0 0 5px;
            color: yellow; /* Zmieniony kolor tytułu na żółty */
            font-size: 1.2em; /* Zmniejszona czcionka o 20% */
        }
        .card.info p {
            margin: 0;
            padding: 0 5px; /* Dodaj padding, aby tekst nie dotykał krawędzi */
            font-size: 0.8em; /* Zmniejszona czcionka o 20% */
        }
        .rating {
            margin: 5px 0;
            font-size: 1.2em; /* Możesz dostosować rozmiar gwiazdek według potrzeb */
        }
        .rating span {
            color: orange; /* Kolor gwiazdek na pomarańczowy */
        }
        @keyframes rotateAround {
            0% {
                transform: rotateY(0deg);
            }
            100% {
                transform: rotateY(360deg);
            }
        }
    </style>
</head>
<body>
    <div class="background" id="background"></div>
    <div class="container">
        <div class="card-wrapper">
            <div class="card underlay" id="poster-card">
                <img src="https://image.tmdb.org/t/p/w500<?php echo htmlspecialchars($top_posters[0]); ?>" alt="Film Poster">
            </div>
            <div class="card info" id="info-card">
                <h2 id="movie-title"><?php echo htmlspecialchars($top_titles[0]); ?></h2>
                <p id="movie-description"><?php echo htmlspecialchars($top_descriptions[0]); ?></p>
                <div class="rating" id="movie-rating">
                    <?php echo str_repeat('<span>&#9733;</span>', floor($top_ratings[0] / 2)) . str_repeat('<span>&#9734;</span>', 5 - floor($top_ratings[0] / 2)); ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const background = document.getElementById('background');
            const posterCard = document.getElementById('poster-card');
            const infoCard = document.getElementById('info-card');
            const titleElement = document.getElementById('movie-title');
            const ratingElement = document.getElementById('movie-rating');
            const descriptionElement = document.getElementById('movie-description');
            const topPosters = <?php echo json_encode($top_posters); ?>;
            const topTitles = <?php echo json_encode($top_titles); ?>;
            const topRatings = <?php echo json_encode($top_ratings); ?>;
            const topDescriptions = <?php echo json_encode($top_descriptions); ?>;
            let currentIndex = 0;

            function updateContent() {
                const poster = topPosters[currentIndex];
                const title = topTitles[currentIndex];
                const rating = topRatings[currentIndex];
                const description = topDescriptions[currentIndex];
                
                background.style.backgroundImage = `url('https://image.tmdb.org/t/p/original${poster}')`;
                posterCard.querySelector('img').src = `https://image.tmdb.org/t/p/w500${poster}`;
                titleElement.textContent = title;
                ratingElement.innerHTML = `${'<span>&#9733;</span>'.repeat(Math.round(rating / 2))}${'<span>&#9734;</span>'.repeat(5 - Math.round(rating / 2))}`;
                descriptionElement.textContent = description;
            }

            function cycleContent() {
                updateContent();
                currentIndex = (currentIndex + 1) % topPosters.length;
                setTimeout(cycleContent, 12000); // Zmieniaj plakat i informacje co 12 sekund
            }

            cycleContent(); // Rozpocznij cykl
        });
    </script>
</body>
</html>
