<?php
include('includes/header.php');

// Table name
$table_name = "playlist";

// Table call
$res = json_decode(file_get_contents('data.json'), true);

// Function to calculate the difference in days between two dates (date only, no time)
function remainingDays($expirationDate) {
    $expiration = new DateTime($expirationDate);
    $today = new DateTime();
    
    // Reset time to avoid time differences
    $today->setTime(0, 0);
    $expiration->setTime(0, 0);
    
    return $today->diff($expiration)->days;
}

// Categorize clients according to expiration
$clientsToday = array_filter($res, function($user) {
    return remainingDays($user['expiration']) == 0;
});
$clients1Day = array_filter($res, function($user) {
    return remainingDays($user['expiration']) == 1;
});
$clients3Days = array_filter($res, function($user) {
    return remainingDays($user['expiration']) == 3;
});
$clients5Days = array_filter($res, function($user) {
    return remainingDays($user['expiration']) == 5;
});

// Add 1 month to expiration
if (isset($_GET['renew'])) {
    $id = $_GET['renew'] - 1;
    $currentExpiration = new DateTime($res[$id]['expiration']);
    $currentExpiration->modify('+1 month');
    $res[$id]['expiration'] = $currentExpiration->format('Y-m-d');
    file_put_contents('data.json', json_encode($res)); // Save to JSON
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=3'</script>";
}
?>

<div class="col-md-12 mx-auto">
    <div class="card-body">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-clock-o"></i> Clients Near Expiration</h2>
                </center>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php 
                    // Function to display each group of clients with colors
                    function displayClients($title, $clients, $color) { ?>
                        <div class="col-md-3">
                            <div class="card text-white <?= $color ?> mb-3">
                                <div class="card-header"><?= $title ?></div>
                                <div class="card-body">
                                    <?php if (empty($clients)) { ?>
                                        <p>No clients.</p>
                                    <?php } else { ?>
                                        <table class="table table-striped table-sm text-white">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Expiration</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($clients as $key => $user) { ?>
                                                <tr>
                                                    <td><?= $user['name'] ?></td>
                                                    <td><?= (new DateTime($user['expiration']))->format('d/m/Y') ?></td>
                                                    <td>
                                                        <a href="?renew=<?= $key + 1 ?>" class="btn btn-success btn-sm">Renew</a>
                                                        <a href="https://wa.me/55<?= preg_replace('/\D/', '', $user['whatsapp']) ?>?text=Hello%20<?= urlencode($user['name']) ?>,%20your%20plan%20expires%20<?= urlencode((new DateTime($user['expiration']))->format('d/m/Y')) ?>.%20Don't%20forget%20to%20renew%20your%20access." target="_blank" class="btn btn-info btn-sm">WhatsApp</a>
                                                    </td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php }
                    
                    // Displaying client boxes expiring today, in 1 day, 3 days and 5 days with specified colors
                    displayClients("Expiring Today", $clientsToday, 'bg-danger'); // Red
                    displayClients("Expiring in 1 Day", $clients1Day, 'bg-warning'); // Yellow
                    displayClients("Expiring in 3 Days", $clients3Days, 'bg-primary'); // Blue
                    displayClients("Expiring in 5 Days", $clients5Days, 'bg-success'); // Green
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
